//	    File: IOHIDDevice_.h
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	Abstract: convieance functions for IOHIDDeviceGetProperty
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	 Version: 2.0
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	Disclaimer: IMPORTANT:  This Apple software is supplied to you by Apple
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	Inc. ("Apple") in consideration of your agreement to the following
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	terms, and your use, installation, modification or redistribution of
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	this Apple software constitutes acceptance of these terms.  If you do
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	not agree with these terms, please do not use, install, modify or
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	redistribute this Apple software.
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	In consideration of your agreement to abide by the following terms, and
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	subject to these terms, Apple grants you a personal, non-exclusive
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	license, under Apple's copyrights in this original Apple software (the
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	"Apple Software"), to use, reproduce, modify and redistribute the Apple
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	Software, with or without modifications, in source and/or binary forms;
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	provided that if you redistribute the Apple Software in its entirety and
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	without modifications, you must retain this notice and the following
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	text and disclaimers in all such redistributions of the Apple Software.
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	Neither the name, trademarks, service marks or logos of Apple Inc. may
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	be used to endorse or promote products derived from the Apple Software
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	without specific prior written permission from Apple.  Except as
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	expressly stated in this notice, no other rights or licenses, express or
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	implied, are granted by Apple herein, including but not limited to any
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	patent rights that may be infringed by your derivative works or by other
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	works in which the Apple Software may be incorporated.
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	The Apple Software is provided by Apple on an "AS IS" basis.  APPLE
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS.
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	IN NO EVENT SHALL APPLE BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION,
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	MODIFICATION AND/OR DISTRIBUTION OF THE APPLE SOFTWARE, HOWEVER CAUSED
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	AND WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE),
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	POSSIBILITY OF SUCH DAMAGE.
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	Copyright (C) 2009 Apple Inc. All Rights Reserved.
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
//	
//*****************************************************
#ifndef __IOHIDDevice__
#define __IOHIDDevice__

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"

//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidDevice( inIOHIDDeviceRef )
	//
	// Purpose:	validate this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	Boolean			- TRUE if we find the device in our( internal ) device list
	//
	
	extern Boolean HIDIsValidDevice(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransport( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transport CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Transport CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetTransport(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorID( inIOHIDDeviceRef )
	//
	// Purpose:	get the vendor ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the vendor ID for this device
	//
	
	extern long IOHIDDevice_GetVendorID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVendorIDSource( inIOHIDDeviceRef )
	//
	// Purpose:	get the VendorIDSource for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VendorIDSource for this device
	//
	
	extern long IOHIDDevice_GetVendorIDSource(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProductID( inIOHIDDeviceRef )
	//
	// Purpose:	get the product ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the product ID for this device
	//
	
	extern long IOHIDDevice_GetProductID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetVersionNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the VersionNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the VersionNumber for this device
	//
	
	extern long IOHIDDevice_GetVersionNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetManufacturer( inIOHIDDeviceRef )
	//
	// Purpose:	get the Manufacturer CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Manufacturer CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetManufacturer(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetProduct( inIOHIDDeviceRef )
	//
	// Purpose:	get the Product CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the Product CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetProduct(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetSerialNumber( inIOHIDDeviceRef )
	//
	// Purpose:	get the SerialNumber CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the SerialNumber CFString for this device
	//
	
	extern CFStringRef IOHIDDevice_GetSerialNumber(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetCountryCode( inIOHIDDeviceRef )
	//
	// Purpose:	get the CountryCode CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the CountryCode for this device
	//
	
	extern long IOHIDDevice_GetCountryCode(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetLocationID( inIOHIDDeviceRef )
	//
	// Purpose:	get the location ID for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the location ID for this device
	//
	
	extern long IOHIDDevice_GetLocationID(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the usage page for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	uint32_t - the usage page for this device
	//
	
	extern uint32_t IOHIDDevice_GetUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetUsagePairs( inIOHIDDeviceRef )
	//
	// Purpose:	get the UsagePairs CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFArrayRef - the UsagePairs for this device
	//
	
	extern CFArrayRef IOHIDDevice_GetUsagePairs(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetPrimaryUsagePage( inIOHIDDeviceRef )
	//
	// Purpose:	get the PrimaryUsagePage CFString for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	CFStringRef - the PrimaryUsagePage CFString for this device
	//
	
	extern uint32_t IOHIDDevice_GetPrimaryUsagePage(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxInputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxInputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxInputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxInputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxOutputReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxOutputReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxOutputReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxOutputReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetMaxFeatureReportSize( inIOHIDDeviceRef )
	//
	// Purpose:	get the MaxFeatureReportSize for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the MaxFeatureReportSize for this device
	//
	
	extern long IOHIDDevice_GetMaxFeatureReportSize(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetReportInterval( inIOHIDDeviceRef )
	//
	// Purpose:	get the ReportInterval for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	long - the ReportInterval for this device
	//
	
	extern long IOHIDDevice_GetReportInterval(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetQueue( inIOHIDDeviceRef )
	//
	// Purpose:	get the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDQueueRef - the Queue for this device
	//
	
	extern IOHIDQueueRef IOHIDDevice_GetQueue(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetQueue( inIOHIDDeviceRef, inQueueRef )
	//
	// Purpose:	Set the Queue for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inQueueRef - the Queue
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetQueue(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDQueueRef inQueueRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_GetTransaction( inIOHIDDeviceRef )
	//
	// Purpose:	get the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//
	// Returns:	IOHIDTransactionRef - the Transaction for this device
	//
	
	extern IOHIDTransactionRef IOHIDDevice_GetTransaction(IOHIDDeviceRef inIOHIDDeviceRef);
	
	//*************************************************************************
	//
	// IOHIDDevice_SetTransaction( inIOHIDDeviceRef, inTransactionRef )
	//
	// Purpose:	Set the Transaction for this device
	//
	// Inputs:  inIOHIDDeviceRef - the IDHIDDeviceRef for this device
	//			inTransactionRef - the Transaction
	//
	// Returns:	nothing
	//
	
	extern void IOHIDDevice_SetTransaction(IOHIDDeviceRef inIOHIDDeviceRef, IOHIDTransactionRef inTransactionRef);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDDevice__ //
